*use /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/macro_q

/* graphs */
label var year_q "Year"

/* hours per worker, rhs=hours only, or gdp+LC/l */
*twoway line lhrsworker lhrsworkerhat2003_5 lhrsworkerhat2003_9b year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lhrsworkerhat,replace) legend(off) text(6.08 1975 "Actual") text(5.84 1998 "Predicted with GDP, costs per worker") text(5.94 2006.5 "Predicted") text(5.92 2006.5 "with total hours")

* forget rhs=hours only, and use gdp+LC/L, starting at 2003 or 2008
label var lhrsworker "Hours per worker"
label var lhrsworkerhat2003_9b "Predicted with change in GDP, per worker labor costs"
label var lhrsworkerhat2007_9b "Predicted with GDP, per worker labor costs"
label var year_q " "
*twoway line lhrsworker lhrsworkerhat2007_9b lhrsworkerhat2003_9b year_q,scheme(s1mono) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lhrsworkerhat,replace) legend(style(column)) lcolor(gs0 gs5 gs5) lpattern(l - _)

twoway line lhrsworker  lhrsworkerhat2003_9b lhrsworkerhat2003_ecm lhrsworkerhat2007_ecm year_q,scheme(s1mono) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lhrsworkerhat,replace) legend(style(column)) lcolor(gs0 gs5 gs5 gs5) lpattern(l _ - -)

graph export lhrsworkerhat.eps, replace logo(off) mag(140)

* version for talk
label var lhrsworker " "
twoway line lhrsworker year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lhrsworkerhatt,replace) lcolor(gs0 orange green) lpattern(l - _) legend(off)
graph export tlhrsworkerhat.eps, replace logo(off) mag(130)

label var lhrsworker " "
twoway line lhrsworker lhrsworkerhat2007_9b year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lhrsworkerhattb,replace) lcolor(gs0 orange green) lpattern(l - _) legend(off)
graph export tlhrsworkerhatb.eps, replace logo(off) mag(130)

label var lhrsworker " "
twoway line lhrsworker lhrsworkerhat2007_9b lhrsworkerhat2003_9b year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lhrsworkerhattc,replace) lcolor(gs0 orange green) lpattern(l - _) legend(off)
graph export tlhrsworkerhatc.eps, replace logo(off) mag(130)

* same for employment 
*label var lemplhat2003_3b "Predicted:GDP, costs per worker, trend"
*label var lemplhat2003_7 "Predicted:total hours, trend"
*twoway line lempl lemplhat2003_7 lemplhat2003_3b year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lemplhat,replace)

twoway line lempl lemplhat2003_3b lemplhat2003_lags year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lemplhat,replace)

* forget case with total hours on rhs
label var lemplhat2003_lags "Predicted with lagged GDP, per worker labor costs"
label var lempl "Employment"
label var lemplhat2003_lags_hi "95% confidence interval"
label var lemplhat2003_lags_lo "95% confidence interval"
twoway rarea lemplhat2003_lags_hi lemplhat2003_lags_lo year_q,color(gs14)  lwidth(none)||line lemplhat2003_lags lemplhat2003_ecm year_q,lpattern(- _) color(gs5) ||line lempl year_q,scheme(s1mono) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lemplhat,replace) legend(order(4 2 1 3) style(column)) lcolor(gs0 gs5) lpattern(l)

graph export lemplhat.eps, replace logo(off) mag(140)

/*
* for talk
label var lempl " "
twoway line lempl year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lemplhatt,replace) legend(off) lcolor(gs0 orange) lpattern(l -)
graph export tlemplhat.eps, replace logo(off) mag(130)

label var lempl " "
twoway line lempl lemplhat2003_3b year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lemplhattb,replace) legend(off) lcolor(gs0 orange) lpattern(l -)
graph export tlemplhatb.eps, replace logo(off) mag(130)


/* repeat for estimation from 1991+ only */
* employment - looks similar
twoway line lempl lemplhat2003_15 lemplhat2003_16 year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lemplhat91,replace)

/* repeat with components of GDP  and pop*/
* employment
twoway line lempl lemplhat2003_3b lemplhat2003_3c lemplhat2003_17 year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lemplhat,replace)

* total hours
twoway line lhourswork lhoursworkhat2003_3b lhoursworkhat2003_3c year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lhoursworkhat,replace)

/* graph gdp on its own */
twoway line lgdp_r year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lgdp_r,replace)
graph export lgdp_r.ps,as(ps) replace logo(off) mag(140) orientation(landscape)

* same for total hours
twoway line lhourswork year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lhourswork,replace)
graph export lhourswork.ps,as(ps) replace logo(off) mag(140) orientation(landscape)

* same for labor costs per hour (adjusted for KA) 
* put productivity on same graph
gen prodvy=gdp_r/hourswork
label var year_q " "
twoway line costperhadj_r year_q||line prodvy year_q,yaxis(2)||,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010,alternate) saving(costperhadj_r,replace) ytitle(Cost per hour,axis(1)) ytitle(Productivity per hour,axis(2)) legend(off) text(4.5 1977.5 "Labor cost") text(3.8 1985.5 "Productivity") title("A. Costs and productivity, 1970-2010",position(11) size(medium))

graph export costperhadj_r.eps, replace logo(off) mag(140)

label var year_q "Year"
* also need close up for 2000-2010
gen ho=year_q*100
label define hlbl 200400 "Q1 2004" 200500 "Q1 2005" 200600 "Q1 2006" 200700 "Q1 2007" 200800 "Q1 2008" 200900 "Q1 2009" 201000 "Q1 2010"
label values ho hlbl
label var ho " "

twoway line costperhadj_r ho||line prodvy ho,yaxis(2)|| if year>=2004&year<=2010,scheme(s1color) saving(costperhadj_rb,replace) ytitle(Cost per hour,axis(1)) xlabel(200400 200500 200600 200700 200800 200900 201000,val angle(vertical)) ytitle(Productivity per hour,axis(2)) legend(off) text(6.57 200600 "Productivity") text(6.3 200950 "Labor cost")  title("B. Costs and productivity, 2004-2010",position(11) size(medium))

graph export costperhadj_rb.eps, replace logo(off) mag(140)

label var year_q " "
* also plot unit labor costs/labor's share/lohnstueckkosten
gen lshare=entgeltAN_r/gdp_r
twoway line lshare year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010,alternate) saving(lshare,replace) ytitle(" ")  title("C. Unit labor costs/labor's share, 1970-2010",position(11) size(medium))

twoway line lshare ho if year>=2004&year<=2010,scheme(s1color) saving(lshareb,replace) ytitle(" ") xlabel(200400 200500 200600 200700 200800 200900 201000,val angle(vertical))  title("D. Unit labor costs/labor's share, 2004-2010",position(11) size(medium))

graph combine costperhadj_r.gph costperhadj_rb.gph lshare.gph lshareb.gph, scheme(s1color) imargin(tiny)
graph export laborcosts.eps, replace logo(off) mag(140)


drop ho

/* graph value added and employment by sector - skip agriculture
   just do since 1991 so can see fluctuations better */
label var vaman_r "Manufacturing"
label var vacons_r "Construction"
label var vafin_r "FIRE"
label var vaserv_r "Other services"
label var vatrade_r "Trade, hospitality"
label var year_q " "
twoway line vaman_r vacons_r vatrade_r vafin_r vaserv_r year_q,scheme(s1mono) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(va_ind,replace) legend(off) text(115 1975 "Manufacturing",size(small)) text(30 2006.5 "Construction",size(small)) text(153 2005.6 "FIRE",size(small)) text(75 2005.5 "Trade",size(small)) text(100 2005.5 "Other services",size(small)) title("A. Value added",position(11) size(medium)) ytitle("Billions of 2000 Euros") ylabel(,val angle(horizontal)) lpattern(-)
graph export va_ind.ps,as(ps) replace logo(off) mag(150)

label var year_q " "
label var emplman "Manufacturing"
label var emplcons "Construction"
label var emplfin "FIRE"
label var emplserv "Other services"
label var empltrade "Trade, hospitality"

twoway line emplman  emplcons  empltrade  emplfin  emplserv  year_q,scheme(s1mono) ytitle("Thousands") xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(empl_ind,replace)  legend(off) text(10400 1980 "Manufacturing",size(small)) text(2900 2006.5 "Construction",size(small)) text(5600 2005.6 "FIRE",size(small)) text(9400 2005.5 "Trade",size(small)) text(12400 2005 "Other services",size(small)) title("B. Employment",position(11) size(medium)) ylabel(,val angle(horizontal)) lpattern(-)
graph export empl_ind.ps,as(ps) replace logo(off) mag(150)

graph combine va_ind.gph empl_ind.gph,col(1) scheme(s1color)
graph export va_empl.eps, replace logo(off) mag(150)

* do differently for talk
twoway line emplman  emplcons  empltrade  emplfin  emplserv  year_q,scheme(s1color) ytitle("Thousands") xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(templ_ind,replace)  legend(off) text(10400 1980 "Manufacturing") text(2900 2006.5 "Construction") text(5600 2005.6 "FIRE") text(9400 2005.5 "Trade") text(12400 2005 "Other services") ylabel(,val angle(horizontal))
graph export templ_ind.eps, replace logo(off) mag(130)


twoway line vaman_r vacons_r vatrade_r vafin_r vaserv_r year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(tva_ind,replace) legend(off) text(115 1975 "Manufacturing") text(30 2006.5 "Construction") text(153 2005.6 "FIRE") text(75 2005.5 "Trade") text(100 2005.5 "Other services") ytitle("Billions of 2000 Euros") ylabel(,val angle(horizontal))
graph export templ_va.eps, replace logo(off) mag(130)


/* total hours */
twoway line lhourswork lhoursworkhat2003_3b year_q,scheme(s1color) xlabel(1970 1975 1980 1985 1990 1995 2000 2005 2010) saving(lemplhat,replace) legend(style(column)) lcolor(gs0 gs5) lpattern(l -)
graph export totalhours.eps, replace logo(off) mag(130)

/*

* fuse the two post-unification series
replace unempu=unempunew if unempu==.

twoway line unempus unempd unempu year_q,scheme(s1color) ylabel(0 2 4 6 8 10 12) xlabel(1960 1965 1970 1975 1980 1985 1990 1995 2000 2005 2010) legend(label(1 "United States") label(2 "West Germany") label(3 "Germany")) 

*graph export unemp.ps,as(ps) replace logo(off) mag(140) orientation(landscape)
